#### Scripts for Session 02 of Modelling with R

require(MASS)
require(lattice)
names(whiteside)
# _[1] "Insul" "Temp"  "Gas"
xyplot(Gas ~ Temp | Insul, whiteside,
	panel = function(x, y, ...) {
		panel.xyplot(x, y, ...)
		panel.lmline(x, y, col = 3)
	}, as.table = T, aspect = 0.61)

xyplot(Gas ~ Temp | Insul, whiteside, panel = function(x, y, ...) {
		panel.xyplot(x, y, ...)
		panel.lmline(x, y, col=3)
	}, as.table = TRUE, aspect = 0.61,
	ylim = c(0, max(whiteside$Gas)+0.5),
	xlab = "Temperature",
	ylab = "Gas consumption",
	main = "Whiteside data on domestic gas consumption",
	layout = c(2,1))

xyplot(Gas ~ Temp | Insul, whiteside,
	xlab = "External temperature",
	ylab = "Gas consumption",
	main = "Whiteside heating data", aspect = 0.6,
	panel = function(x, y, ...) {
		panel.xyplot(x, y, ...)
		panel.lmline(x, y, ..., col = 3)
		}, scales = list(relation = "free"))


trellis.device(x11)

sps <- trellis.par.get("superpose.symbol")
sps
# _$cex:
# _[1] 0.8 0.8 0.8 0.8 0.8 0.8 0.8
# _
# _$col:
# _[1] 2 3 4 5 6 7 8
# _
# _$font:
# _[1] 1 1 1 1 1 1 1
# _
# _$pch:
# _[1] 1 1 1 1 1 1 1
# _
sps$pch <- 1:7

trellis.par.set("superpose.symbol", sps)

xyplot(Time ~ Viscosity, stormer, groups = Wt, type = "b",
	main = "Stormer viscometer calibration data")

dev.off()

xyplot(Time ~ Viscosity, stormer, groups = Wt,
	type = "b", auto.key = TRUE,
	main = "Stormer viscometer calibration data")

find("volcano.S")  # courtesy Ross Ihaka
# _[1] "package:datasets"
class(volcano)
# _[1] "matrix"
dim(volcano)
# _[1] 87 61

# volcano <- as.matrix(volcano)
x <- 10*(1:nrow(volcano))
y <- 10*(1:ncol(volcano))
vdat <- transform(expand.grid(x = x, y = y),
			 v = as.vector(volcano))

levelplot(v ~ x*y, vdat,
  col.regions = heat.colors(256),
  main = "Maunga Whau Volcano")

levelplot(v ~ x*y, vdat, contour = TRUE,
  pretty = TRUE,
  col.regions = topo.colors(256),
  main = "Maunga Whau Volcano")
  
wireframe(v ~ x*y, vdat, drape = TRUE,
  col.regions = terrain.colors(256),
  main = "Maunga Whau Volcano")

require(rgl)
z <- 2 * volcano        # Exaggerate the relief

x <- 10 * (1:nrow(z))   # 10 meter spacing (S to N)
y <- 10 * (1:ncol(z))   # 10 meter spacing (E to W)

zlim <- range(z)
zlen <- zlim[2] - zlim[1] + 1

colorlut <- topo.colors(zlen) # height color lookup table

col <- colorlut[ z-zlim[1]+1 ] # assign colors to heights for each point

open3d()
surface3d(x, y, z, color=col, back="lines")





